/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.entity;

import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sekelsta.horse_colors.CreativeTab;
import sekelsta.horse_colors.client.renderer.HorseGeneticRenderer;
import sekelsta.horse_colors.entity.DonkeyGeneticEntity;
import sekelsta.horse_colors.entity.HorseGeneticEntity;
import sekelsta.horse_colors.entity.MuleGeneticEntity;

@Mod.EventBusSubscriber(modid="horse_colors", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntities {
    public static EntityType<HorseGeneticEntity> HORSE_GENETIC = null;
    public static EntityType<DonkeyGeneticEntity> DONKEY_GENETIC = null;
    public static EntityType<MuleGeneticEntity> MULE_GENETIC = null;
    public static SpawnEggItem HORSE_SPAWN_EGG = null;
    public static SpawnEggItem DONKEY_SPAWN_EGG = null;
    public static SpawnEggItem MULE_SPAWN_EGG = null;
    public static final int horseEggPrimary = 8340256;
    public static final int horseEggSecondary = 1117709;

    private static void registerAttributes() {
        GlobalEntityTypeAttributes.put(HORSE_GENETIC, (AttributeModifierMap)AbstractHorseEntity.func_234237_fg_().func_233813_a_());
        GlobalEntityTypeAttributes.put(DONKEY_GENETIC, (AttributeModifierMap)AbstractChestedHorseEntity.func_234234_eJ_().func_233813_a_());
        GlobalEntityTypeAttributes.put(MULE_GENETIC, (AttributeModifierMap)AbstractChestedHorseEntity.func_234234_eJ_().func_233813_a_());
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{HORSE_GENETIC, DONKEY_GENETIC, MULE_GENETIC});
        ModEntities.registerAttributes();
    }

    @SubscribeEvent
    public static void registerSpawnEggs(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)HORSE_SPAWN_EGG);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(HORSE_GENETIC, renderManager -> new HorseGeneticRenderer(renderManager));
        RenderingRegistry.registerEntityRenderingHandler(DONKEY_GENETIC, renderManager -> new HorseGeneticRenderer(renderManager));
        RenderingRegistry.registerEntityRenderingHandler(MULE_GENETIC, renderManager -> new HorseGeneticRenderer(renderManager));
    }

    static {
        ResourceLocation horseRegistryName = new ResourceLocation("horse_colors", "horse_felinoid");
        HORSE_GENETIC = EntityType.Builder.func_220322_a(HorseGeneticEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.2f, 1.6f).func_206830_a(horseRegistryName.toString());
        HORSE_GENETIC.setRegistryName(horseRegistryName);
        ResourceLocation donkeyRegistryName = new ResourceLocation("horse_colors", "donkey");
        DONKEY_GENETIC = EntityType.Builder.func_220322_a(DonkeyGeneticEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.2f, 1.6f).func_206830_a(donkeyRegistryName.toString());
        DONKEY_GENETIC.setRegistryName(donkeyRegistryName);
        ResourceLocation muleRegistryName = new ResourceLocation("horse_colors", "mule");
        MULE_GENETIC = EntityType.Builder.func_220322_a(MuleGeneticEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.2f, 1.6f).func_206830_a(muleRegistryName.toString());
        MULE_GENETIC.setRegistryName(muleRegistryName);
        HORSE_SPAWN_EGG = new SpawnEggItem(HORSE_GENETIC, 8340256, 1117709, new Item.Properties().func_200916_a((ItemGroup)CreativeTab.instance));
        HORSE_SPAWN_EGG.setRegistryName(new ResourceLocation("horse_colors", "horse_spawn_egg"));
        DONKEY_SPAWN_EGG = new SpawnEggItem(DONKEY_GENETIC, 7496791, 13484213, new Item.Properties().func_200916_a((ItemGroup)CreativeTab.instance));
        DONKEY_SPAWN_EGG.setRegistryName(new ResourceLocation("horse_colors", "donkey_spawn_egg"));
        MULE_SPAWN_EGG = new SpawnEggItem(MULE_GENETIC, 4930096, 13482408, new Item.Properties().func_200916_a((ItemGroup)CreativeTab.instance));
        MULE_SPAWN_EGG.setRegistryName(new ResourceLocation("horse_colors", "mule_spawn_egg"));
    }
}

